import acm.program.*;
import java.util.*;

public class Problem3 extends ConsoleProgram {
    public void run() {
        println(getCharacterCount("ATTTGCCA"));
        println(getCharacterCount("Everyone's welcome!"));
        println(getCharacterCount("successfully"));

        println(getFirstNonRepeat("ATTTGCCA"));
        println(getFirstNonRepeat("Everyone's Welcome"));
        println(getFirstNonRepeat("successfully"));
        println(getFirstNonRepeat("toot"));
    }

    /* Answer for 3A */
    // don't worry about importing packages
    private HashMap<Character, Integer> getCharacterCount(String str) {
        HashMap<Character, Integer> map = new HashMap<Character, Integer>();
        for (int i = 0; i < str.length(); i++) {
            char ch = str.charAt(i);
            if (Character.isLetter(ch)) {
                ch = Character.toUpperCase(ch);
                if (map.containsKey(ch)) {
                    map.put(ch, map.get(ch) + 1);
                } else {
                    map.put(ch, 1);
                }
            }
        }

        return map;
    }

    /* Answer for 3B */
    // don't worry about importing packages
    private Character getFirstNonRepeat(String str) {
        HashMap<Character, Integer> charCount = getCharacterCount(str);
        for (int i = 0; i < str.length(); i++) {
            char ch = str.charAt(i);
            if (Character.isLetter(ch)) {
                ch = Character.toUpperCase(ch);
                if (charCount.get(ch) == 1) return ch;
            }
        }

        return null;
    }
}
